#!/usr/bin/perl
use Digest::MD5 qw(md5 md5_hex md5_base64);


# Ponymath instructions for use:
# 1. Make sure you have installed perl, mencoder with x264 support and gnuplot.
# 2. Configure all the parameters below.
# 3. Run ponymath. It'll make a bit of clutter in the current directory.
# 4. One of those clutter files will be graph.png. It's a heat map. You can read those, I hope? Good.
# 5. Encode your video with the optimal values according to graph.png. Then compare to an encode with defaults - ponymath is a guide, not an oracle. It can be wrong.

# You can kill and resume any time you want - those lot-o-hex.log files are the cached encode results, so it can resume.
# For the curious wondering why this is called Ponymath: During development I used a clip from Friendship is Magic that I grabbed off youtube for testing purposes. Thus I named the folder 'ponymath' and just never thought up a better name.

my $x264encopts="bitrate=800:qpmin=1"; #Must include at least one option, the bitrate. Don't use CQ or lax ratecontrol - you need all these encodes to have the same bitrate for comparison purposes.
my $startpos="0:35:0"; #Set the start of the clip for testing in the input file. Make both this and $cliplength empty to just test the whole file, but that will be *slow*.
my $cliplength="0:10:0"; #Testing the whole file will very time consuming on many files, thus the support for clips.
my $inputfile="~/data/lugiavid.avi"; #This one is fairly obvious.
my $minA=-3;my $maxA=1; #Range for Alpha.
my $minB=-3;my $maxB=1; #Range for Beta.

#End of configuration. Real program starts here.


if($startpos ne ""){
  $startpos="-ss $startpos";
}
if($cliplength ne ""){
  $cliplength="-endpos $cliplength";
}
open OUTTEXT, ">out.txt";
my $minssim=1;my $maxssim=0;
#$x, $y, alpha and beta respectively
for(my $x=$minA;$x<=$maxA;$x++){
  for(my $y=$minB;$y<=$maxB;$y++){
    my $line="mencoder $inputfile $startpos $cliplength -o /dev/null -nosound -ovc x264 -x264encopts ssim:tune=ssim:filter=$x,$y:$x264encopts";
    my $keyfile=md5_hex($line).".log";
    if(not -e $keyfile){
#      print $line;
      `$line 2> temp.log 1> /dev/null`;
      `mv temp.log $keyfile`;
    }
    $ret=`cat $keyfile | grep SSIM`;
    $ret=substr($ret,25,9);print OUTTEXT "$x $y $ret\n";print "$x $y $ret\n";
    if($ret < $minssim){
      $minssim=$ret;
    }
    if($ret > $maxssim){
      $maxssim=$ret;
    }
  }
}
close OUTTEXT;
open GRAPHTEXT, ">graph.txt";
print GRAPHTEXT "set title \"$x264encopts\";";
print GRAPHTEXT "set cbrange [$minssim:$maxssim]\n";
print GRAPHTEXT "set cblabel \"SSIM\"\nset xlabel \"Alpha\"\nset ylabel \"Beta\"\n";
print GRAPHTEXT "set xrange [$minA:$maxA]\nset yrange [$minB:$maxB]\n";
print GRAPHTEXT "set view map\n";
print GRAPHTEXT "set output \"graph_filter.png\"\n";
print GRAPHTEXT "set terminal png\n";
print GRAPHTEXT "plot 'out.txt' using 1:2:3 with image title ''";
close GRAPHTEXT;

`gnuplot graph.txt`;
