#!/usr/bin/perl
use Digest::MD5 qw(md5 md5_hex md5_base64);

#See ponymath_2D.pl for instructions.
#Ponymath_1D is a modified version of Ponymath which alters only one parameter.

my $x264encopts="threads=4:bitrate=700:me=umh"; #Must include at least one option, the bitrate. Don't use CQ or lax ratecontrol - you need all these encodes to have the same bitrate for comparison purposes.
my $startpos="0:35:0"; #Set the start of the clip for testing in the input file. Make both this and $cliplength empty to just test the whole file, but that will be *slow*.
my $cliplength="0:10:0"; #Testing the whole file will very time consuming on many files, thus the support for clips.
my $inputfile="~/data/lugiavid_readytoencode.avi"; #This one is fairly obvious.
my $param="merange";
my $min=8;my $max=64;my $step=4; #Range/step

#End of configuration. Real program starts here.


if($startpos ne ""){
  $startpos="-ss $startpos";
}
if($cliplength ne ""){
  $cliplength="-endpos $cliplength";
}
open OUTTEXT, ">out.txt";
my $minssim=1;my $maxssim=0;
#$x, $y, alpha and beta respectively
for(my $x=$min;$x<=$max;$x+=$step){
    my $line="mencoder $inputfile $startpos $cliplength -o /dev/null -nosound -ovc x264 -x264encopts ssim:tune=ssim:$param=$x:$x264encopts";
    my $keyfile=md5_hex($line).".log";
    if(not -e $keyfile){
      print "Testing $line\n";
      `$line 2> temp.log 1> /dev/null`;
      `mv temp.log $keyfile`;
    }
    $ret=`cat $keyfile | grep SSIM`;
    $ret=substr($ret,25,9);print OUTTEXT "$x $ret\n";print "$x $ret\n";
    if($ret < $minssim){
      $minssim=$ret;
    }
    if($ret > $maxssim){
      $maxssim=$ret;
    }
}
close OUTTEXT;
open GRAPHTEXT, ">graph.txt";
#print GRAPHTEXT "set cbrange [$minssim:$maxssim]\n";
#print GRAPHTEXT "set cblabel \"SSIM\"\nset xlabel \"Alpha\"\nset ylabel \"Beta\"\n";
print GRAPHTEXT "set title \"$x264encopts\";";
print GRAPHTEXT "set xrange [$min:$max]\nset yrange [$minssim:$maxssim]\n";
#print GRAPHTEXT "set view map\n";
print GRAPHTEXT "set xlabel \"$param\"\n";
print GRAPHTEXT "set output \"graph_$param.png\"\n";
print GRAPHTEXT "set terminal png\n";
print GRAPHTEXT "plot 'out.txt' title ''";
close GRAPHTEXT;

`gnuplot graph.txt`;
