#include "berlekamp.c"
#include "galois.c"
#include "rs.c"
#include "ecc.h"
#include "HDLC.cpp"
#include "birdmodem.cpp"
#include "poll.h"
#include <stdio.h>
#include <stdint.h>
#include <pthread.h>
#define NPAR 12 //Number of FEC bytes.

void printhelp();
void transmit_thread();
void receive_thread();
void process_decoded_frame(hdlc_receiver *receiver);
void* newthread(void* argument);
void apply_RS_FEC(hdlc_composer *composer);
void apply_RS_FEC_dec(hdlc_receiver *receiver);

bool fec=true;
bool lb=true;
int main(int argc, char *argv[]){
  initialize_ecc();
  bool tx=false;
  bool rx=false;
  for(int n=0;n<argc;n++){
    if(!strcmp(argv[n], "-t"))
      tx=true;
    if(!strcmp(argv[n], "-r"))
      rx=true;
    if(!strcmp(argv[n], "-nofec"))
      fec=false;
    if(!strcmp(argv[n], "-b"))
      lb=false;
    if(!strcmp(argv[n], "-h"))
      printhelp();
  }

  if(tx==false && rx==false){
    fprintf(stderr,"At least one of -t or -r must be specified.\n");
    return(1);
  }
  if(tx==false && lb==false){
    fprintf(stderr,"-b specified without -t. -b Does nothing in receive mode, so this was probably not intended.\n");
    return(1);
  }
  if(tx==false && rx==true){
    receive_thread();
  }
  if(tx==true && rx==false){
    transmit_thread();
  }
  if(tx==true && rx==true){
    pthread_t thread;
    int foo=0;
    pthread_create(&thread, NULL, newthread, &foo);
    transmit_thread();
  }
}

void printhelp(){
  printf("Minibird is a simple modem program for transferring data over sound using the 'Bird modem' transport. It operates at a fixed bit rate of 2450bps raw, but due to overheads of syncronisation and error correction has a usable byte rate of approximately 270B/s. This is still more than twice the performance of minimodem in a 3KHz, AC-coupled signal that can be transmitted over a channel intended for voice. The Bird modem was specifically designed with amateur radio in mind, for use with low-cost voice-only FM radios.\n\n  This performance comes at a cost: Though twice the speed of Bell 202/minimodem, the bird modem has substantially worse noise immunity.\n\n -r\tReceive mode.\n -t\tTransmit mode.\n\tSpecifiy -r and -t for full duplex.\n -nofec\tDisable FEC, substantially improving throughput - and utterly ruining noise immunity.\n -b\tBinary mode - disables flushing on every newline. Faster, but not suitable for interactive use.\n\n");
  exit(0);
}
void* newthread(void* argument) {
  receive_thread();
}

uint8_t *receive_inhibit;
void receive_thread(){
  birdmodem_RX rxmodem(128+4+NPAR); //128 payload, 4 CRC, 8 FEC.
  rxmodem.set_callback(&process_decoded_frame);
  
  if(fec)
    rxmodem.set_post_receive_function(&apply_RS_FEC_dec);
  rxmodem.receive_thread();
}

void transmit_thread(){
  birdmodem_TX composer(128+4+NPAR); //128 payload, 4 CRC, 8 FEC.
  if(fec)
    composer.pre_send_function=&apply_RS_FEC;
  struct pollfd fdset[1];
  memset(fdset, 0, sizeof(fdset));
  fdset[0].fd=STDIN_FILENO;
  fdset[0].events=POLLIN;
  int count=0;
  char framedone=0;
  bool first=true;
  do{
    framedone=0;
    count=0;
    do{
      char nextc=fgetc(stdin);
      composer.frame[count++]=nextc;
      if((lb && nextc=='\n') || count==128)
        framedone=1;
      if(feof(stdin)){
        framedone=2;count--;}
    }while(!framedone);
    composer.frame_length=count;
    if(first){
      composer.send_sync_sequence(100);
      first=false;
    }
    composer.send_frame();

    poll(fdset,1,0);
    if(!(fdset[0].revents && POLLIN)){ //Out of data! This is to be expected if the user is typing. Just need to handle it.
      composer.send_sync_sequence(100);
      first=true; //Make quite sure the next transmission gets the required preamble.
    }
  }while(framedone!=2);
  composer.send_sync_sequence(100);
}

void process_decoded_frame(hdlc_receiver *receiver){
//  rxmodem.receive_inhibit=16;
  fwrite(receiver->frame, 1, receiver->frame_length-4, stdout);
}



void apply_RS_FEC(hdlc_composer *composer){
  encode_data(composer->frame, composer->frame_length,composer->frame);
  composer->frame_length+=NPAR;
}
void apply_RS_FEC_dec(hdlc_receiver *receiver){

  if(receiver->frame_length<(4+1+NPAR))
    return;
  receiver->frame_length-=NPAR;
  if(receiver->verify_checksum())
    return;
  
  decode_data(receiver->frame, receiver->frame_length+NPAR);
  if (check_syndrome () != 0)
    correct_errors_erasures (receiver->frame, receiver->frame_length+NPAR,0,NULL);
//  if(receiver->verify_checksum())
  //  fprintf(stderr,"Frame fixed.\n");
}
