#include <Magick++.h>
#include <string.h>
#define _UNICODE
#include <math.h>

using namespace Magick;

int main(int argc, char *argv[]){
  if(argc<=1){
    printf("scanalize <file> [image]\n  Generates a graphical display of statistics about the file.\n  Scanalise was designed as a tool to visualise the effect of various compression algorithms and transformations.\n  If [image] is specified, output will be saved as an image file (type determined by extension) rather than displayed.\n  Specifiy file as - to read from stdin.\n");
    return(1);
  }

  //I tried using static arrays. It didn't work. Can't figure out why, but malloc works.
  unsigned int *valcounters=(unsigned int*)malloc(256*sizeof(unsigned int));
  unsigned int *correlation=(unsigned int*)malloc(256*256*sizeof(unsigned int));
  unsigned int *bits=(unsigned int*)malloc(8*sizeof(unsigned int));
//  for(int n=0;n<256;n++)
//    valcounters[n]=0;
  for(int y=0;y<256;y++)
    for(int x=0;x<256;x++)
      correlation[(256*y)+x]=0;
//  for(int n=0;n<256;n++){
//    printf("Odd: %u, %u\n", n, correlation[(256*n)+255]);
//  }

  unsigned char *buffer=(unsigned char*)malloc(512);
  unsigned char lastchar=0;
  unsigned int runs=1;
  unsigned long long total_delta=0;
  unsigned int totalbytes=0;

  FILE *infile=stdin;
  if(strcmp(argv[1], "-"))
    infile=fopen(argv[1], "rb");
//  for(int n=0;n<256;n++)
//    printf("%u:%u\n", n, valcounters[n]);
  while(!feof(infile)){
    unsigned int bytesread=fread(buffer, 1, 512, infile);
//    printf("Chunk\n");
    for(int n=0;n<bytesread;n++){
//      totalbytes++;
      valcounters[buffer[n]]++;
      if(buffer[n]&0x01)
        bits[0]++;
      if(buffer[n]&0x02)
        bits[1]++;
      if(buffer[n]&0x04)
        bits[2]++;
      if(buffer[n]&0x08)
        bits[3]++;
      if(buffer[n]&0x10)
        bits[4]++;
      if(buffer[n]&0x20)
        bits[5]++;
      if(buffer[n]&0x40)
        bits[6]++;
      if(buffer[n]&0x80)
        bits[7]++;
      correlation[(lastchar*256)+buffer[n]]++;
      if(buffer[n]!=lastchar){
        total_delta+=abs(buffer[n]-lastchar);
        lastchar=buffer[n];
        runs++;
      }
    }
  }
  printf("Done reading, calculating stats.\n");
  unsigned int maxbytes=1;
  unsigned long long sigma=0;
  for(int n=0;n<256;n++){
    totalbytes+=valcounters[n];
    sigma+=valcounters[n]*n;
//    printf("%u:%u\n", n, valcounters[n]);
    if(maxbytes<valcounters[n])
      maxbytes=valcounters[n];
  }
  fclose(infile);
  float mu=sigma/(float)totalbytes;
  float deviation=0;
  for(int n=0;n<256;n++){
    deviation+=valcounters[n]*abs(n-mu);
  }
  deviation=sqrt(deviation/totalbytes);
//  printf("Total bytes: %u\n", totalbytes);
  InitializeMagick(*argv);
  Image output_image("512x380", "white");
//  output_image.read("test.jpg");

// set the text font: the font is specified via a string representing
// a fully qualified X font name (wildcards '*' are allowed)

  output_image.fillColor(Color(Color(MaxRGB/2, MaxRGB/2, MaxRGB/2, 0)));
  output_image.draw(DrawableRectangle(256, 0,512,255));
  output_image.fillColor(Color(Color(0, 0, 0, 0)));

  char textlabel[256];
  for(int n=0;n<256;n++){
    int top=n;
    int width=((double)valcounters[n]/(double)maxbytes)*255;
    output_image.draw(DrawableRectangle(256, top,256+width,top));
  }


//  for(int n=0;n<256;n++){
//    printf("Odd: %u, %u\n", n, correlation[(256*n)+255]);
//  }
  for(int y=0;y<256;y++)
    for(int x=0;x<256;x++){
      if(valcounters[y]&&correlation[(256*y)+x]){
        unsigned int c=(256*correlation[(256*y)+x])/valcounters[y];
        c-=128;
        c*=(MaxRGB/128);
        output_image.pixelColor(x,y,Color((MaxRGB/2)+c,(MaxRGB/2)-c,MaxRGB/2,0));
      }else
        output_image.pixelColor(x,y,Color(0,0,0,0));
//      if(!valcounters[x])
//        output_image.pixelColor(x,y,Color(MaxRGB,MaxRGB,MaxRGB,0));

    }
  output_image.fillColor(Color(Color(MaxRGB/2, MaxRGB/2, MaxRGB/2, 0)));
  output_image.draw(DrawableRectangle(400, 260,500,324));
  output_image.fillColor(Color(Color(0,0,0,0)));
  output_image.draw(DrawableRectangle(400, 260,400+(100*((float)bits[0]/totalbytes)),268));
  output_image.draw(DrawableRectangle(400, 268,400+(100*((float)bits[1]/totalbytes)),276));
  output_image.draw(DrawableRectangle(400, 276,400+(100*((float)bits[2]/totalbytes)),284));
  output_image.draw(DrawableRectangle(400, 284,400+(100*((float)bits[3]/totalbytes)),292));
  output_image.draw(DrawableRectangle(400, 292,400+(100*((float)bits[4]/totalbytes)),300));
  output_image.draw(DrawableRectangle(400, 300,400+(100*((float)bits[5]/totalbytes)),308));
  output_image.draw(DrawableRectangle(400, 308,400+(100*((float)bits[6]/totalbytes)),316));
  output_image.draw(DrawableRectangle(400, 316,400+(100*((float)bits[7]/totalbytes)),324));

std::list<Drawable> text_draw_list;
output_image.fontPointsize(18);
//text_draw_list.push_back(DrawableFont("@/usr/share/fonts/truetype/ttf-dejavu/DejaVuSans.ttf"));
//text_draw_list.push_back( DrawableStrokeColor(Color("black")));
//text_draw_list.push_back( DrawableFillColor(Color(0, 0, 0, 0)));
output_image.font("@/usr/share/fonts/truetype/ttf-dejavu/DejaVuSans.ttf");
output_image.draw(DrawableStrokeColor(Color("black")));
output_image.draw(DrawableFillColor(Color(0, 0, 0, 0)));

  sprintf(textlabel, "Bytes: %u\nRuns: %u\nAvg. Run len: %1.2f\navg |X\u2099-X\u2099\u208B\u2081|: %1.2f", totalbytes, runs, (float)totalbytes/runs, (float)total_delta/totalbytes);
  printf("%s\n", textlabel);
  output_image.draw( DrawableText(10, 300, textlabel));
  sprintf(textlabel, "\u03a3X\u2099: %llu\n\u03bc: %1.2f\n\u03c3: %1.2f", sigma, mu, deviation);
  printf("%s\n", textlabel);
  output_image.draw( DrawableText(210, 300, textlabel));
//  sprintf(textlabel, "Runs: %u    Avg. Run len: %u", runs, totalbytes/runs);
//  printf("%s\n", textlabel);
//  text_draw_list.push_back( DrawableText(10, 316, textlabel));
//  sprintf(textlabel, "avg |X\u2099-X\u2099\u208B\u2081|: %llu \u03a3", total_delta/totalbytes);
//  printf("%s\n", textlabel);
//  text_draw_list.push_back(DrawableText(10, 332, textlabel));
//  output_image.draw(DrawableFillColor(Color(0, 0, 0, 0)));
//  output_image.draw(objects_to_draw);


//  output_image.draw( text_draw_list);
  if(argc==2)
    output_image.display();
  else
    output_image.write(argv[2]);

}
