// Creates a shield on impact.
// Smaller than the Arcshield.
class ShieldMissile extends ONSAVRiLRocket;

var Pawn PHomingTarget;

simulated function Timer()
{
    local vector Dir, ForceDir;
    local float VelMag, LowestDesiredZ;
    local bool bLastLockedOn;
    //local int i;
    local actor NewTarget;

    if (Role == ROLE_Authority)
    {
    	if (OverrideTarget == none)
    	{
			if (Instigator != None && Instigator.Controller != None && ONSAVRiL(Owner) != None)
			{
				bLastLockedOn = bLockedOn;
				bLockedOn = ShieldLauncher(Owner).bLockedOn;
				PHomingTarget = ShieldLauncher(Owner).PHomingTarget;
				if (!bLastLockedOn && bLockedOn)
				{
					if (PHomingTarget != None && PHomingTarget.Controller != None)
						HomingTarget.Controller.ReceiveProjectileWarning(self);
				}
			}
			else
				bLockedOn = false;
		}
		else
			bLockedOn = true;


    }

    if (bLockedOn && ( PHomingTarget != none || OverrideTarget != none) )
    {
		if (OverrideTarget != none)
		{
			if ( VSize(OverrideTarget.Location - Location ) < 256 )
			{
				OverrideTarget.Destroy();
				TakeDamage(20000,none, Location, Velocity, none);
				return;
			}
			NewTarget = OverrideTarget;
		}

		else
			NewTarget = PHomingTarget;

    	// Do normal guidance to target.
		if ( Pawn(NewTarget) != None )
			Dir = Pawn(NewTarget).GetTargetLocation() - Location;
		else
    		Dir = NewTarget.Location - Location;
    	VelMag = VSize(Velocity);

		if (Level.TimeSeconds >= LeadTargetStartTime)
		{
	    	ForceDir = Dir + NewTarget.Velocity * VSize(Dir) / (VelMag * 2);

	    	if (Instigator != None)
				LowestDesiredZ = FMin(Instigator.Location.Z, NewTarget.Location.Z); //missle should avoid going any lower than this
			else
				LowestDesiredZ = NewTarget.Location.Z;

			if (ForceDir.Z + Location.Z < LowestDesiredZ)
	    		ForceDir.Z += LowestDesiredZ - (ForceDir.Z + Location.Z);

	    	ForceDir = Normal(ForceDir);
		}
		else
			ForceDir = Dir;

    	ForceDir = Normal(ForceDir * 0.8 * VelMag + Velocity);
    	Velocity =  VelMag * ForceDir;
    	Acceleration += 5 * ForceDir;

    	// Update rocket so it faces in the direction its going.
    	SetRotation(rotator(Velocity));
    }
}

simulated function Destroyed()
{
	// Turn of smoke emitters. Emitter should then destroy itself when all particles fade out.
	if ( SmokeTrail != None )
		SmokeTrail.Kill();

	if ( Corona != None )
		Corona.Destroy();

	//if (!bNoFX && EffectIsRelevant(Location, false))
	//	spawn(class'ONSAVRiLRocketExplosion',,, Location, rotator(vect(0,0,1)));
	if (Instigator != None && Instigator.IsLocallyControlled() && Instigator.Weapon != None && !Instigator.Weapon.HasAmmo())
		Instigator.Weapon.DoAutoSwitch();
	//hack for crappy weapon firing sound
	if (ONSAVRiL(Owner) != None)
		ONSAVRiL(Owner).PlaySound(sound'WeaponSounds.BExplosion3', SLOT_Interact, 0.01,, TransientSoundRadius);

	//Super.Super.Destroyed(); //Skip super!
}

replication
{
	reliable if (bNetDirty && Role == ROLE_Authority)
		PHomingTarget;
}



simulated function BlowUp(vector HitLocation)
{
	if ( Role == ROLE_Authority ){
		MakeNoise(1.0);
		spawn(class'miniShield');
	}
}

defaultproperties
{
     MomentumTransfer=0.000000
     ExplosionDecal=None
     LifeSpan=14.000000
     ForceRadius=0.000000
     ForceScale=0.000000
}
