Class ShieldLauncher extends ONSAVRiL;

var Pawn PHomingTarget;
var FollowShield projectedShield;
var float secondsTick;

simulated function PostBeginPlay(){
	enable('Tick');
	Super.PostBeginPlay();
}
simulated function Tick(float deltaTime){
	if(secondsTick > 0.50000){
		if(projectedShield != None)
			spawn(class'waveyBeam',projectedShield,,Location);
		secondsTick-=0.500;
	}
	secondsTick+=deltaTime;
	Super.Tick(deltaTime);

}

simulated function WeaponTick(float deltaTime)
{
	local vector StartTrace, LockTrace;
	local rotator Aim;
	local float BestAim, BestDist;
	local bool bLastLockedOn, bBotLock;
	local Pawn LastHomingTarget;
	local Pawn AIFocus;
	local Pawn V;
	local Actor AlternateTarget;

	if (Role < ROLE_Authority)
	{
		ActivateReticle(bLockedOn);
		return;
	}

	if (Instigator == None || Instigator.Controller == None)
	{
		LoseLock();
		ActivateReticle(false);
		return;
	}

	if (Level.TimeSeconds < LockCheckTime)
		return;

	LockCheckTime = Level.TimeSeconds + LockCheckFreq;

	bLastLockedOn = bLockedOn;
	LastHomingTarget = PHomingTarget;
	bBotLock = true;
	if (AIController(Instigator.Controller) != None)
	{
		AIFocus = Pawn(AIController(Instigator.Controller).Focus);
		if ( CanLockOnTo(AIFocus) && ((AIFocus.Controller != None) || (AIFocus != Instigator.Controller.MoveTarget))
			&& FastTrace(AIFocus.Location, Instigator.Location + Instigator.EyeHeight * vect(0,0,1)) )
		{
			PHomingTarget = AIFocus;
			bLockedOn = true;
		}
		else
		{
			bLockedOn = false;
			bBotLock = false;
		}
	}
	else if ( PHomingTarget == None || Normal(PHomingTarget.Location - Instigator.Location) Dot vector(Instigator.Controller.Rotation) < LockAim
		  || VSize(PHomingTarget.Location - Instigator.Location) > MaxLockRange
		  || !FastTrace(PHomingTarget.Location, Instigator.Location + Instigator.EyeHeight * vect(0,0,1)) )
	{
		StartTrace = Instigator.Location + Instigator.EyePosition();
		Aim = Instigator.GetViewRotation();
		BestAim = LockAim;

		PHomingTarget = Instigator.Controller.PickTarget(BestAim, BestDist, Vector(Aim), StartTrace, MaxLockRange);
	}

	// If no homing target, check for alternate targets
	if (PHomingTarget == None)
	{
		StartTrace = Instigator.Location + Instigator.EyePosition();
		Aim = Instigator.GetViewRotation();

		foreach allactors(class'Pawn', V)
		{
            AlternateTarget = V;

            if (AlternateTarget != None)
            {
                LockTrace = AlternateTarget.Location - StartTrace;
                if ( (Normal(LockTrace) dot Vector(Aim)) > LockAim && VSize(LockTrace) < MaxLockRange && FastTrace(AlternateTarget.Location,StartTrace) )
                {
                    PHomingTarget = V;
                    if ( AIController(Instigator.Controller) != none)
                    	AIController(Instigator.Controller).Focus = V;
                    break;
                }
            }
        }
    }

	bLockedOn = CanLockOnTo(PHomingTarget);

	ActivateReticle(bLockedOn);
	if (!bLastLockedOn && bLockedOn)
	{
		if ( bBotLock && (PHomingTarget != None) && (V != None) && V.IsA('Vehicle'))
			Vehicle(PHomingTarget).NotifyEnemyLockedOn();
		if ( PlayerController(Instigator.Controller) != None )
			PlayerController(Instigator.Controller).ClientPlaySound(Sound'WeaponSounds.LockOn');
	}
	else if (bLastLockedOn && !bLockedOn && LastHomingTarget != None && (V != None) && V.IsA('Vehicle'))
		Vehicle(LastHomingTarget).NotifyEnemyLostLock();
	if(Level.NetMode != NM_Client){
		if(bLockedOn && (projectedShield==None) && canProjectShield(PHomingTarget) && FireMode[1].bIsFiring){
			projectedShield=Spawn(class'FollowShield', PHomingTarget);
		}
		if(!bLockedOn || !FireMode[1].bIsFiring)
			if(projectedShield != None)
				projectedShield.Destroy();
	}
}

function bool CanLockOnTo(Actor Other)
{
    local Pawn V;
    V = Pawn(Other);

    if (V == None || V == Instigator)
        return false;
    return(true); //You want to be able to lock onto friendlies to project a shield.

//    if (!Level.Game.bTeamGame)
//        return true;

//    return (V.PlayerReplicationInfo.Team.TeamIndex != Instigator.PlayerReplicationInfo.Team.TeamIndex);
}

function bool canProjectShield(Actor Other){
    local Pawn V;
    if (!Level.Game.bTeamGame)
        return false;
    V = Pawn(Other);
    if (V == None || V == Instigator)
        return false;
    if(!V.IsA('xPawn'))
      return(false);
    if(V.PlayerReplicationInfo == None)
      return(false);

    return (V.PlayerReplicationInfo.Team.TeamIndex == Instigator.PlayerReplicationInfo.Team.TeamIndex);
}

function LoseLock()
{
	if (bLockedOn && PHomingTarget != None && PHomingTarget.IsA('Vehicle'))
		HomingTarget.NotifyEnemyLostLock();
	bLockedOn = false;
	if(projectedShield != None)
		projectedShield.Destroy();
}

function float GetAIRating()
{
	local Bot B;
	local float ZDiff, dist, Result;

	local miniShield N;
	foreach CollidingActors(class'minishield', N, 1024)
		return 0; //Already trapped.

	B = Bot(Instigator.Controller);
	if ( (B.Target != None) && B.Target.IsA('ONSMortarCamera') )
		return 2;

	if ( (B == None) || (B.Enemy == None) )
		return AIRating;

	if (B.Enemy.IsA('ONSAttackCraft'))
		return 1.0;

	dist = VSize(B.Enemy.Location - Instigator.Location);
	if(dist<1024)
		return 0; //Not a short-range weapon.

	result = 0.550000; //Old AVRiL rating.
	ZDiff = Instigator.Location.Z - B.Enemy.Location.Z;
	if ( ZDiff < -200 )
		result += 0.1;
	if ( dist >= 2048 )
		return ( FMin(2.0,result + (dist - 2000) * 0.0002) );

	return result;
}


replication
{
	reliable if (bNetDirty && bNetOwner && Role == ROLE_Authority)
		PHomingTarget, projectedShield;
}

defaultproperties
{
     MaxLockRange=30000.000000
     FireModeClass(0)=Class'shieldGens.ShieldFire'
     FireModeClass(1)=Class'shieldGens.ShieldAltFire'
     AIRating=0.200000
     Description="Launched by the AVRiL launcher, the Shield Missile will immobilise enemies and shelter strategic targets. It can also project a defensive bubble around an ally, providing line of sight is maintained."
     Priority=53
     ItemName="Shield launcher"
}
