Class ArcShield extends Actor;

var() sound shieldsound;

function PreBeginPlay(){
	//SetDrawScale3D(Vect(10,10,5));
	PlaySound(shieldsound,,4);
}

function Destroyed(){
	PlaySound(shieldsound,,4);
}

function TakeDamage(int Damage, Pawn EventInstigator, vector HitLocation, vector Momentum, class<DamageType> DamageType){
	local PSGVech owningvech;
	//spawn(class'xEffects.NewIonEffect',,,HitLocation);
	//spawn(class'xEffects.IonCannonDeathEffect',,,HitLocation); //Shieldlost
	owningvech=PSGVech(Owner);
	if(owningvech==None)
		Destroy();
	else
		owningvech.TakeShieldDamage(Damage, EventInstigator, HitLocation, Momentum, Damagetype);
}

defaultproperties
{
     shieldsound=Sound'GeneralAmbience.beep10'
     DrawType=DT_StaticMesh
     StaticMesh=StaticMesh'shieldGens.ShieldSphere'
     bTrailerSameRotation=True
     Physics=PHYS_Trailer
     DrawScale3D=(X=10.000000,Y=10.000000,Z=5.000000)
     bCollideActors=True
     bBlockActors=True
     bBlockProjectiles=True
     bBlockKarma=True
}
