class TubeSegmentFourth extends Actor;

#exec NEW STATICMESH NAME=BrokenTubeForthMesh FILE=Models\TubeForth.ase

var int Health;

event TakeDamage(int Damage, Pawn EventInstigator, vector HitLocation, vector Momentum, class<DamageType> DamageType)
{
  local Rotator newrot;
  if(Health<=0){
    Velocity+=Momentum;
    return;
  }
  Health-=Damage;
  if(Health<=0){
    LifeSpan=10+(Rand(200)/100);
    SetPhysics(PHYS_Falling);
    SetCollision(false, false, false);
    Velocity+=Momentum;
    newrot.Pitch=(Rand(2048)-1024)*Damage/8;
    newrot.Yaw=(Rand(2048)-1024)*Damage/8;
    newrot.Roll=(Rand(2048)-1024)*Damage/8;
    RotationRate=newrot;
  }
  newrot.Pitch=Rotation.Pitch+((Rand(2048)-1024)*Damage/32);
  newrot.Yaw=Rotation.Yaw+((Rand(2048)-1024)*Damage/32);
  newrot.Roll=Rotation.Roll;
  SetRotation(newrot);
}

defaultproperties
{
     Health=70
     DrawType=DT_StaticMesh
     StaticMesh=StaticMesh'SeriesOfTubes.BrokenTubeForthMesh'
     bIgnoreVehicles=True
     Skins(0)=Texture'SeriesOfTubes.TubeTex1'
     bCanBeDamaged=True
     bCollideActors=True
     bCollideWorld=True
     bBlockActors=True
     bBlockPlayers=True
     bBlockKarma=True
}
