class TubeSegment extends Actor;

#exec NEW STATICMESH NAME=BrokenTubeMesh FILE=Models\BrokenTube.ase
#exec NEW TEXTURE NAME=TubeTex1 File=Textures\TubeTex1.bmp
#exec NEW TEXTURE NAME=TubeTex2 File=Textures\TubeTex2.bmp
#exec NEW TEXTURE NAME=TubeTex3 File=Textures\TubeTex3.bmp
#exec NEW TEXTURE NAME=TubeTex4 File=Textures\TubeTex4.bmp
#exec NEW TEXTURE NAME=TubeTex5 File=Textures\TubeTex5.bmp
#exec NEW TEXTURE NAME=TubeTex6 File=Textures\TubeTex6.bmp
#exec NEW TEXTURE NAME=TubeTex7 File=Textures\TubeTex7.bmp

var int Health;
var float spawnEffectDuration;

function postBeginPlay()
{
	setTimer(spawnEffectDuration, false);
}

function timer()
{

}

event TakeDamage(int Damage, Pawn EventInstigator, vector HitLocation, vector Momentum, class<DamageType> DamageType)
{
  local Rotator newrot;
  Health-=Damage;
  if(Health<=0){
    newrot=Rotation;
    Spawn(class'TubeSegmentFourth',,,Location, newRot);//.skins[0]=skins[0];
    newrot.Roll=newrot.Roll+(65536/4);
    Spawn(class'TubeSegmentFourth',,,Location, newRot);//.skins[0]=skins[0];
    newrot.Roll=newrot.Roll+(65536/4);
    Spawn(class'TubeSegmentFourth',,,Location, newRot);//.skins[0]=skins[0];
    newrot.Roll=newrot.Roll+(65536/4);
    Spawn(class'TubeSegmentFourth',,,Location, newRot);//.skins[0]=skins[0];
     Destroy();
  }
  newrot.Pitch=Rotation.Pitch+((Rand(2048)-1024)*Damage/16);
  newrot.Yaw=Rotation.Yaw+((Rand(2048)-1024)*Damage/16);
  newrot.Roll=Rotation.Roll;
  SetRotation(newrot);
}

defaultproperties
{
     Health=70
     spawnEffectDuration=1.000000
     DrawType=DT_StaticMesh
     StaticMesh=StaticMesh'SeriesOfTubes.BrokenTubeMesh'
     bIgnoreVehicles=True
     Skins(0)=Texture'SeriesOfTubes.TubeTex1'
     bCanBeDamaged=True
     bCollideActors=True
     bCollideWorld=True
     bBlockActors=True
     bBlockPlayers=True
     bBlockKarma=True
}
