class TubeMakerGuidedFire extends RedeemerFire;

function Projectile SpawnProjectile(Vector Start, Rotator Dir)
{
    local GuidedtubeMaker Warhead;
	local PlayerController Possessor;
	
    Warhead = Weapon.Spawn(class'GuidedTubeMaker', Instigator,, Start, Dir);
    if (Warhead == None)
		Warhead = Weapon.Spawn(class'GuidedTubeMaker', Instigator,, Instigator.Location, Dir);
    if (Warhead != None)
    {
		Warhead.OldPawn = Instigator;
		Warhead.PlaySound(FireSound,,,,,1);
		Possessor = PlayerController(Instigator.Controller);
		Possessor.bAltFire = 0;
		if ( Possessor != None )
		{
			if ( Instigator.InCurrentCombo() )
				Possessor.Adrenaline = 0;
			Possessor.UnPossess();
			Instigator.SetOwner(Possessor);
			Instigator.PlayerReplicationInfo = Possessor.PlayerReplicationInfo;
			Possessor.Possess(Warhead);
		}
		Warhead.Velocity = Warhead.AirSpeed * Vector(Warhead.Rotation);
		Warhead.Acceleration = Warhead.Velocity;
		WarHead.MyTeam = Possessor.PlayerReplicationInfo.Team;
    }


	bIsFiring = false;
    StopFiring();
    return None;
}

defaultproperties
{
     FireSound=Sound'WeaponSounds.BaseFiringSounds.BFlakCannonAltFire'
     AmmoClass=Class'SeriesOfTubes.TubeAmmo'
}
