class ShurikenProjectile extends Projectile;

// #exec STATICMESH IMPORT FILE="staticmeshes/glaive.lwo" NAME="GlaiveLWO" GROUP="GSSAL"
#exec NEW STATICMESH FILE="staticmeshes/glaive.ase" NAME="GlaiveASE" GROUP="GSSAL"

var Sound wallHitSound;
var int numWallHits; // number of times the shuriken has hit a wall
var int maxWallHits; // number of times it can hit a wall before it is destroyed

simulated function postbeginplay()
{
 local rotator r;
 super.postbeginplay();

 velocity = speed*vector(rotation);

 // unfortunately, rotation seems to occur on global axes, not relative to the shuriken.
 // in other words, if you fire straight up, the shuriken will point upward, but it will
 // yaw on the universal yaw axis, not its own, and thus will seem to be rolling instead.

 // therefore, rotation needs to be on two axes - yawing if the shuriken is moving horizontally
 // and rolling if it's moving vertically.

 r = rotation;
 r.yaw = rand(65535);
 setRotation(r);
}

simulated function hitwall(vector hitnorm, actor wall)
{
 local float dotp; 
 // vehicles count as walls, therefore do the damage here if it doesn't get handled in processtouch

  spawn(class'xEffects.wallsparks',,,location, rotator(hitnorm));
  playsound(wallhitsound);

  dotp = velocity Dot hitnorm;

  velocity = (velocity-dotp*hitnorm) - (dotp*hitnorm);
  numWallHits++;

  if (numWallHits > maxWallHits)
   destroy();

  setrotation(rotator(velocity));
  
  // destroy();


 // shurikens only do half damage to vehicles
 if (vehicle(wall) != none)
   vehicle(wall).takedamage(damage/2, instigator, location, normal(velocity)*momentumtransfer, mydamagetype);

}

simulated function ProcessTouch (Actor Other, vector HitLocation)
{
    if (Other == Instigator && numWallHits == 0) return;
    if (Other == Owner) return;

 if (Other.IsA('xPawn'))
     Pawn(Other).TakeDamage(damage, Instigator, Location, normal(velocity)*momentumtransfer, MyDamageType);

 // only half damage to powernodes and powercores
 if (onspowercore(other) != none)
 {
  onspowercore(other).takedamage(damage/2, instigator, location, normal(velocity)*momentumtransfer, mydamagetype);
  spawn(class'xEffects.wallsparks',,,hitlocation,);
  playsound(wallhitsound);

  destroy();
 }
}

defaultproperties
{
     wallHitSound=Sound'WeaponSounds.BaseImpactAndExplosions.BBulletImpact11'
     maxWallHits=8
     Speed=2000.000000
     Damage=90.000000
     MyDamageType=Class'GSSAL.DamTypeGSSALShuriken'
     DrawType=DT_StaticMesh
     StaticMesh=StaticMesh'GSSAL.GlaiveASE'
     AmbientSound=Sound'CicadaSnds.Missile.MissileFlight'
     LifeSpan=16.000000
     DrawScale3D=(X=1.100000,Y=1.100000)
     Skins(0)=TexEnvMap'VMVehicles-TX.Environments.ReflectionEnv'
     SoundVolume=255
     SoundRadius=255.000000
     CollisionRadius=20.000000
     CollisionHeight=4.000000
     bFixedRotationDir=True
     RotationRate=(Yaw=90000)
}
