// The Thunderbird is a heavy weapons platform - just as the Phoenix is specialised in anti-infantry and area denial, the Thunderbird is specialised to take down slow or fixed targets with very high HP. It's weakness is a lack of armor leaving it vulnerable to counterattack.

Class ONSThunderbirdCraftGun extends ONSWeapon;

//#exec OBJ LOAD FILE=..\Animations\ONSWeapons-A.ukx

//var float MinAim;


function byte BestMode()
{

		return 0;
}

function TraceFire(Vector Start, Rotator Dir)
{
    local Vector X, End, HitLocation, HitNormal;

    X = Vector(Dir) + (VRand()*0.05);
    X = X / VSize(X);
    End = Start + TraceRange * X;
    Trace(HitLocation, HitNormal, End, Start, True);
    if(HitLocation != Vect(0,0,0))
      Spawn(Class'ThunderbirdDeathRay',Owner,,HitLocation+(Hitnormal*128)+(VRand()*256), Rot(0,0,0));
    NetUpdateTime = Level.TimeSeconds - 1;
}

state InstantFireMode
{

  function AltFire(Controller C){
    Local ThunderbirdBomb bomb;
    bomb=spawn(Class'ThunderbirdBomb',Owner,,Owner.location+Vect(0,0,-150));
    bomb.Velocity=Owner.Velocity+Vect(0,0,-200);
    bomb.Instigator=Owner.Instigator;
    gotostate('broke'); //Comment this out for testing.
  }


}

state broke
{
}

defaultproperties
{
     YawBone="PlasmaGunBarrel"
     PitchBone="PlasmaGunBarrel"
     PitchUpLimit=18000
     PitchDownLimit=49153
     WeaponFireAttachmentBone="PlasmaGunBarrel"
     RotationsPerSecond=1.200000
     bInstantFire=True
     FireInterval=0.200000
     AltFireInterval=6.400000
     AltFireSoundClass=Sound'ONSVehicleSounds-S.AVRiL.AvrilFire01'
     FireForce="Laser01"
     AltFireForce="Laser01"
     TraceRange=32768.000000
     AIInfo(0)=(bLeadTarget=True,RefireRate=0.950000)
     AIInfo(1)=(bLeadTarget=True,aimerror=400.000000,RefireRate=0.500000)
     Mesh=SkeletalMesh'ONSWeapons-A.PlasmaGun'
}
