class MegaSplatHelper extends Actor;


var Sound megaSplatSound;
var sound extrememegasplatsound;
var int amountGibs;
var Pawn Victim;

simulated function PostBeginPlay(){
  local Pawn findTarget;
  local xPawn xVictim;
  local int i, baseGibAmount, gibNo;
  local Gib gib;
  local xEmitter bloodExplosion;
  local flashexplosion flash;


  Victim=Pawn(Owner);

  if(Victim==None)
    foreach RadiusActors(class'Pawn', findTarget, 64)
      if(Victim == None)
        Victim=findTarget;
      else
        if(VSize(Victim.Location-Location)>VSize(findTarget.Location-Location))
          victim=findTarget;

  if((Victim == None) || (Victim == Instigator)){
    return;
  }  

  SetLocation(Victim.location);

  xVictim=xPawn(Victim);

  if (xVictim != None)
  {
    bloodexplosion = spawn(xvictim.gibgroupclass.default.bloodgibclass, , ,location, rotation);
    bloodexplosion.msizerange[0] = 80;
    bloodexplosion.msizerange[1] = 160;

    // bloodexplosion.remoterole = role_none;

   // calculate a base number of gibs per size of victim - large monsters produce more gibs.
   // since this gun is supposed to make a huge mess we'll inflate the number of gibs anyway, but it just
   // makes it more fun to blow up big monsters.

   // this is about 1 gib per 'normal sized' monster (44 height, 25 radius)
   baseGibAmount = victim.collisionradius*victim.collisionHeight/1100;

   gibNo = amountGibs * baseGibAmount;

   if (gibNo < 1)
    gibNo = 4+rand(4); // if monster is too small to produce gibs, add in a few

   // double the gibs for a player kill
   if (monster(xVictim) != none)
    gibNo *= 2;

   // 1 in 10 chance of it maybe being a very messy explosion
   if (rand(10) == 0)
   {
    gibNo += rand(gibNo);
    gibNo *= 2;
    megaSplatSound = extrememegasplatsound;
    flash = spawn(class'xEffects.flashexplosion',,,location);
    flash.setdrawscale(flash.default.drawscale * basegibamount);
   }

   for (i=0; i < gibNo; i++)
   {
    gib = spawn(xvictim.gibGroupClass.default.gibs[rand(5)],,, location, rotation);

    // small monsters would produce very small gibs, which looks a little rubbish, so we don't apply the scaling to them
    if (baseGibAmount >= 1)
     gib.setDrawScale(gib.drawscale * baseGibAmount);

    // gib.trail.lifespan=16;

    gib.spawntrail();

    gib.velocity = vrand()*(500+rand(1000));

    // slow the gibs down a little for players, it doesn't look right when they explode quickly
    if (Monster(xVictim) == none)
     gib.velocity /= 1.1;

     // gib.remoterole = role_none;

   }
  }

  victim.playSound(megaSplatSound);
  if(level.netmode != nm_client)
    Victim.died(Instigator.Controller, Class'DamTypeGSSALLightning', Victim.Location);
  Victim.SetDrawType(DT_None); //Don't destroy just yet.
}

simulated function Destroyed(){
  if(Victim != None)
    Victim.Destroy(); //No corpse, just splat.
}

defaultproperties
{
     megaSplatSound=Sound'CicadaSnds.Decoy.DecoyLaunch'
     extrememegasplatsound=Sound'onsbpsounds.shocktank.ShockBallExplosion'
     amountGibs=41
     DrawType=DT_None
     bAlwaysRelevant=True
     RemoteRole=ROLE_SimulatedProxy
     LifeSpan=5.000000
     SoundRadius=200.000000
}
