class ChainMegaSplatHelper extends MegaSplatHelper;


simulated function PreBeginPlay(){
  if(Level.NetMode != NM_Client)
    LifeSpan=RandRange(0.2,0.8);
  Super.PreBeginPlay();
}


simulated function Destroyed(){
  local Pawn findTarget;
  local bool doneOnce;
  if(Victim != None)
    Victim.Destroy(); //No corpse, just splat.
  foreach RadiusActors(class'Pawn', findTarget, 384)
    if((findTarget.DrawType) != DT_None && (findTarget != instigator) && (Level.Game.ReduceDamage(20, findTarget, instigator, location, Velocity, Class'DamTypeGSSALLightning') > 0))
    {
      if(Level.NetMode != NM_Client)
        Spawn(class'ChainMegaSplatHelper', findTarget,,findTarget.location);
      spawn(class'ChainLightningBolt',Self,,findTarget.Location);
      if(doneOnce) //The arcs should fork.
        return;
      doneOnce=true;
    }
}

defaultproperties
{
     amountGibs=15
     LifeSpan=0.000000
}
