class SuricouProjectile extends Projectile;

var Sound wallHitSound;

simulated function postbeginplay()
{
 super.postbeginplay();

 velocity = speed*vector(rotation);

 loopanim('SwimF');
}

simulated function hitwall(vector hitnorm, actor wall)
{
 // vehicles count as walls, therefore do the damage here if it doesn't get handled in processtouch

  spawn(class'xEffects.goopsparks',,,location, rotator(hitnorm));
  spawn(class'xEffects.goopsmoke',,,location, rotator(hitnorm));

  playsound(wallhitsound);
  destroy();

 if (vehicle(wall) != none)
   vehicle(wall).takedamage(damage, instigator, location, normal(velocity)*momentumtransfer, mydamagetype);

}

simulated function ProcessTouch (Actor Other, vector HitLocation)
{
    if (Other == Instigator) return;
    if (Other == Owner) return;

 if (Other.IsA('xPawn'))
     Pawn(Other).TakeDamage(damage, Instigator, Location, normal(velocity)*momentumtransfer, MyDamageType);

  destroy();
}

defaultproperties
{
     Speed=1000
     Damage=90
     MomentumTransfer=1000
     MyDamageType=Class'DamTypeGSSALSuricou'

     DrawType=DT_Mesh
       mesh=mesh'SuriRavenAn.SuriRaven'
     Skins(0)=Texture'SuriRavenTx.Suri_Body'
//     bFixedRotationDir=true
//     AmbientSound=Sound''
     SoundVolume=255
     SoundRadius=255
     LifeSpan=32.000000
//     Texture=Texture'XEffectMat.Shock.shock_core_low'
//     DrawScale3D=(X=0.1,Y=0.1,Z=0.2)
     drawscale3D=(x=1.1,y=1.1,z=1)
     CollisionRadius=20.000000
     CollisionHeight=20.000000
     WallHitSound=SoundGroup'WeaponSounds.BioRifle.BioRifleGoo1'
}
